/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.core.auto_update;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.util.UUIDTypeAdapter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.labymod.core.loader.DefaultLabyModLoader;
import net.minecraft.launchwrapper.Launch;
import sun.misc.Unsafe;

public class AutoUpdater {
    private static final byte[] CERTIFICATE = Base64.getDecoder().decode("MIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4WhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJuZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBYMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygch77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6UA5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sWT8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyHB5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UCB5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUvKBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWnOlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTnjh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbwqHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CIrU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkqhkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZLubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KKNFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5ORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7UrTkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdCjNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVcoyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPAmRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57demyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc=");
    public static final String DELETION_MARKER = "File marked for deletion by MagierFlamme Addon updater";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static MethodHandles.Lookup lookup;
    public static boolean hasUpdated;
    private static final char[] HEX_CHARSET;
    public static PlayerKeyPair currentKeyPair;
    private static SSLSocketFactory customFactory;

    private static MethodHandles.Lookup getLookup() {
        if (lookup != null) {
            return lookup;
        }
        try {
            lookup = MethodHandles.lookup();
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            unsafe.putInt(lookup, 12L, -1);
            return lookup;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean update(Init infoProvider) {
        try {
            String entrypoint = AutoUpdater.doUpdate(infoProvider);
            if (entrypoint == null) {
                return false;
            }
            Class<?> c = Class.forName(entrypoint);
            ((Entrypoint)c.getConstructor(new Class[0]).newInstance(new Object[0])).start();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not load MagierFlamme Addon!", e);
        }
    }

    private static String doUpdate(Init infoProvider) throws Throwable {
        if (!AutoUpdater.class.getProtectionDomain().getCodeSource().getLocation().getFile().contains(".jar")) {
            return null;
        }
        File jarFile = new File(AutoUpdater.getOwnJar());
        JsonObject addonJson = AutoUpdater.getAddonJson();
        String laby = infoProvider.getLabyVersion();
        File targetFile = File.createTempFile("magierflamme-addon", ".jar");
        File tmpDir = targetFile.getParentFile();
        if (tmpDir != null && tmpDir.isDirectory()) {
            for (File file : tmpDir.listFiles((dir, name) -> name.startsWith("magierflamme-addon"))) {
                if (file.equals(targetFile) || file.delete()) continue;
                file.deleteOnExit();
            }
        }
        targetFile.deleteOnExit();
        InputStream in = AutoUpdater.read("https://addon-magierflamme.pages.dev/latest");
        if (in == null) {
            throw new RuntimeException("Could not validate license!");
        }
        Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        in.close();
        AutoUpdater.removeURLFromClassLoaders(jarFile.toURI().toURL());
        MethodHandle addURL = AutoUpdater.getLookup().findVirtual(URLClassLoader.class, "addURL", MethodType.methodType(Void.TYPE, URL.class));
        addURL.invoke(AutoUpdater.class.getClassLoader(), targetFile.toURI().toURL());
        hasUpdated = true;
        return String.format("dev.l3g7.magierflamme_addon.labymod.%s.Entrypoint", infoProvider.getLabyVersion());
    }

    private static void checkJarForDeletion(File file, Init infoProvider) throws IOException {
        ZipInputStream in = new ZipInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        ZipEntry entry = in.getNextEntry();
        if (entry == null || !DELETION_MARKER.equals(entry.getComment())) {
            return;
        }
        if (!file.delete()) {
            infoProvider.forceDeleteJar(file);
        }
    }

    private static String getOwnJar() {
        String ownJarUrl = AutoUpdater.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (ownJarUrl.contains("!")) {
            ownJarUrl = ownJarUrl.substring(0, ownJarUrl.lastIndexOf("!"));
        }
        try {
            ownJarUrl = URLDecoder.decode(ownJarUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (ownJarUrl.startsWith("file:/")) {
            ownJarUrl = ownJarUrl.substring(5);
        }
        return ownJarUrl;
    }

    private static void removeURLFromClassLoaders(URL urlToRemove) throws Throwable {
        Class<?> urlClassPathClass;
        try {
            urlClassPathClass = Class.forName("jdk.internal.loader.URLClassPath");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            urlClassPathClass = Class.forName("sun.misc.URLClassPath");
        }
        MethodHandle ucpGetter = AutoUpdater.getLookup().findGetter(URLClassLoader.class, "ucp", urlClassPathClass);
        MethodHandle pathGetter = AutoUpdater.getLookup().findGetter(urlClassPathClass, "path", ArrayList.class);
        MethodHandle lmapGetter = AutoUpdater.getLookup().findGetter(urlClassPathClass, "lmap", HashMap.class);
        MethodHandle loadersGetter = AutoUpdater.getLookup().findGetter(urlClassPathClass, "loaders", ArrayList.class);
        URLClassLoader classLoader = (URLClassLoader)AutoUpdater.class.getClassLoader();
        Object ucp = ucpGetter.invoke(classLoader);
        ArrayList path = pathGetter.invoke(ucp);
        HashMap lmap = lmapGetter.invoke(ucp);
        ArrayList loaders = loadersGetter.invoke(ucp);
        path.remove(urlToRemove);
        Object loader = lmap.remove("file://" + urlToRemove.getFile());
        if (loader == null) {
            return;
        }
        loaders.remove(loader);
        ((Closeable)loader).close();
    }

    private static String hash(File file) throws NoSuchAlgorithmException, IOException {
        byte[] bytes = MessageDigest.getInstance("SHA-256").digest(Files.readAllBytes(file.toPath()));
        char[] res = new char[bytes.length * 2];
        for (int i = 0; i < res.length; i += 2) {
            int b = bytes[i / 2] & 0xFF;
            res[i] = HEX_CHARSET[b >>> 4];
            res[i + 1] = HEX_CHARSET[b & 0xF];
        }
        return new String(res);
    }

    private static InputStream read(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(AutoUpdater.getCustomFactory());
            }
            conn.addRequestProperty("User-Agent", "MagierFlamme Addon");
            conn.setRequestProperty("Authorization", AutoUpdater.generateAuthHeader());
            conn.setConnectTimeout(10000);
            if (conn.getResponseCode() == 401) {
                System.err.println("Invalid MagierFlamme Addon license!");
                try {
                    Unsafe UNSAFE;
                    try {
                        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                        unsafeField.setAccessible(true);
                        UNSAFE = (Unsafe)unsafeField.get(null);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                    Class<?> shutdownClass = Class.forName("java.lang.Shutdown");
                    Method exit = shutdownClass.getDeclaredMethod("exit", Integer.TYPE);
                    UNSAFE.putBoolean(exit, 12L, true);
                    exit.invoke(null, 0);
                }
                catch (ReflectiveOperationException ex) {
                    Runtime.getRuntime().exit(0);
                }
            }
            return conn.getInputStream();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    static String generateAuthHeader() {
        Map launchArgs = (Map)Launch.blackboard.get("launchArgs");
        String token = null;
        String uuidStr = null;
        if (launchArgs == null) {
            List args = DefaultLabyModLoader.getInstance().getArguments();
            for (int i = 0; i < args.size(); i += 2) {
                if (((String)args.get(i)).equals("--accessToken")) {
                    token = (String)args.get(i + 1);
                    continue;
                }
                if (!((String)args.get(i)).equals("--uuid")) continue;
                uuidStr = (String)args.get(i + 1);
            }
        } else {
            token = (String)launchArgs.get("--accessToken");
            uuidStr = (String)launchArgs.get("--uuid");
        }
        if (currentKeyPair == null) {
            currentKeyPair = PlayerKeyPair.getPlayerKeyPair(token).join();
        }
        UUID uuid = UUIDTypeAdapter.fromString((String)uuidStr);
        try {
            return "v2 " + GSON.toJson((Object)new AuthData(uuid, currentKeyPair)).replaceAll("[\r\n]", "");
        }
        catch (GeneralSecurityException t) {
            return null;
        }
    }

    private static SSLSocketFactory getCustomFactory() {
        if (customFactory != null) {
            return customFactory;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            KeyStore defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            defaultKeyStore.load(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]), "changeit".toCharArray());
            for (TrustAnchor ta : new PKIXParameters(defaultKeyStore).getTrustAnchors()) {
                keyStore.setCertificateEntry(UUID.randomUUID().toString(), ta.getTrustedCert());
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            keyStore.setCertificateEntry(UUID.randomUUID().toString(), cf.generateCertificate(new ByteArrayInputStream(CERTIFICATE)));
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            customFactory = sslContext.getSocketFactory();
            return customFactory;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static JsonObject getAddonJson() throws IOException {
        String jarPath = AutoUpdater.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (!jarPath.contains(".jar")) {
            throw new IllegalStateException("Invalid code source location: " + jarPath);
        }
        jarPath = jarPath.substring(5, jarPath.lastIndexOf("!"));
        jarPath = URLDecoder.decode(jarPath, "UTF-8");
        try (JarFile jarFile = new JarFile(jarPath);){
            if (jarFile.size() == 0) {
                throw new IllegalStateException("Empty jar file: " + jarPath);
            }
            Optional<JarEntry> addonJson = jarFile.stream().filter(entry -> entry.getName().equals("addon.json")).findFirst();
            if (addonJson.isPresent()) {
                JsonObject jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(jarFile.getInputStream(addonJson.get())))).getAsJsonObject();
                return jsonObject;
            }
        }
        throw new FileNotFoundException("addon.json");
    }

    static {
        hasUpdated = false;
        HEX_CHARSET = "0123456789abcdef".toCharArray();
        currentKeyPair = null;
        customFactory = null;
    }

    public static interface Init {
        public void forceDeleteJar(File var1) throws IOException;

        public String getLabyVersion();
    }

    public static interface Entrypoint {
        public void start();
    }

    public static class PlayerKeyPair {
        public KeyPair keyPair;
        @SerializedName(value="publicKeySignatureV2")
        public String publicKeySignature;
        @SerializedName(value="expiresAt")
        public String expirationTime;
        private static final ConcurrentHashMap<String, CompletableFuture<PlayerKeyPair>> cache = new ConcurrentHashMap();

        public static CompletableFuture<PlayerKeyPair> getPlayerKeyPair(String authToken) {
            return cache.computeIfAbsent(authToken, key -> CompletableFuture.supplyAsync(() -> {
                try {
                    HttpURLConnection c = (HttpURLConnection)URI.create("https://api.minecraftservices.com/player/certificates").toURL().openConnection();
                    c.setRequestMethod("POST");
                    c.setRequestProperty("Content-Length", "0");
                    c.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                    c.setRequestProperty("Authorization", "Bearer " + authToken);
                    c.setDoOutput(true);
                    c.getOutputStream().close();
                    if (c.getResponseCode() >= 400) {
                        return null;
                    }
                    return (PlayerKeyPair)GSON.fromJson((Reader)new InputStreamReader(c.getInputStream()), PlayerKeyPair.class);
                }
                catch (IOException e) {
                    return null;
                }
            }));
        }

        public PrivateKey getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
            return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(this.getRawPrivateKey()));
        }

        public byte[] getRawPrivateKey() {
            String privateKey = this.keyPair.privateKey.replaceAll("^-----BEGIN RSA PRIVATE KEY-----|-----END RSA PRIVATE KEY-----$|\r|\n", "");
            return Base64.getMimeDecoder().decode(privateKey);
        }

        public String getPublicKey() {
            return this.keyPair.publicKey.replaceAll("^-----BEGIN RSA PUBLIC KEY-----|-----END RSA PUBLIC KEY-----$|\r|\n", "");
        }

        public String getPublicKeySignature() {
            return this.publicKeySignature;
        }

        public long getExpirationTime() {
            return Instant.parse(this.expirationTime).toEpochMilli();
        }

        public static class KeyPair {
            public String privateKey;
            public String publicKey;
        }
    }

    static class AuthData {
        private final UUID user;
        @SerializedName(value="request_time")
        private final long requestTime;
        private final String signature;
        @SerializedName(value="public_key")
        private final String publicKey;
        @SerializedName(value="key_signature")
        private final String keySignature;
        @SerializedName(value="expiration_time")
        private final long expirationTime;

        AuthData(UUID user, PlayerKeyPair keyPair) throws GeneralSecurityException {
            this.user = user;
            this.requestTime = new Date().getTime();
            ByteBuffer signedPayload = ByteBuffer.allocate(24);
            signedPayload.putLong(user.getMostSignificantBits());
            signedPayload.putLong(user.getLeastSignificantBits());
            signedPayload.putLong(this.requestTime);
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(keyPair.getPrivateKey());
            sign.update(signedPayload.array());
            byte[] signature = sign.sign();
            this.signature = Base64.getEncoder().encodeToString(signature);
            this.publicKey = keyPair.getPublicKey();
            this.keySignature = keyPair.getPublicKeySignature();
            this.expirationTime = keyPair.getExpirationTime();
        }
    }
}

