/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.core.injection;

import dev.l3g7.magierflamme_addon.core.api.bridges.LabyBridge;
import dev.l3g7.magierflamme_addon.core.api.file_provider.FileProvider;
import dev.l3g7.magierflamme_addon.core.api.file_provider.meta.ClassMeta;
import dev.l3g7.magierflamme_addon.core.api.mapping.Mapping;
import dev.l3g7.magierflamme_addon.core.api.misc.Constants;
import dev.l3g7.magierflamme_addon.core.api.reflection.Reflection;
import dev.l3g7.magierflamme_addon.core.injection.transformer.Transformer;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.transformer.Config;

public class InjectorBase {
    static Config mixinConfig;
    private static final Map<String, Transformer> transformers;

    public static void initialize(String labymodNamespace, String refmap) {
        MixinBootstrap.init();
        mixinConfig = Config.create((String)"magierflamme_addon.mixins.json", (MixinEnvironment)MixinEnvironment.getDefaultEnvironment());
        Reflection.set((Object)mixinConfig.getConfig(), (String)"refMapperConfig", (Object)("refmaps/" + refmap + ".json"));
        Reflection.invoke(Mixins.class, (String)"registerConfiguration", (Object[])new Object[]{mixinConfig});
        if (labymodNamespace != null) {
            mixinConfig.getConfig().decorate("labymod-namespace", (Object)labymodNamespace);
        }
        for (ClassMeta meta : FileProvider.getClassesWithSuperClass(Transformer.class)) {
            Transformer transformer = (Transformer)Reflection.construct((Class)meta.load(), (Object[])new Object[0]);
            transformers.put(transformer.getTarget(), transformer);
        }
        Reflection.setMappingTarget((Mapping)LabyBridge.labyBridge.activeMapping());
    }

    public boolean shouldTransform(String name, String transformedName) {
        if (name.startsWith("com.github.lunatrius.schematica")) {
            Constants.SCHEMATICA = true;
        } else if (name.startsWith("de.emotechat.addon")) {
            Constants.EMOTECHAT = true;
        } else if (name.startsWith("dev.l3g7.griefer_utils")) {
            Constants.GRIEFERUTILS = true;
        }
        return transformers.containsKey(transformedName);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Transformer transformer = transformers.get(transformedName);
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)classNode, 0);
        transformer.transform(classNode);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        transformers = new HashMap<String, Transformer>();
    }
}

