/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.core.injection.transformer;

import dev.l3g7.magierflamme_addon.core.api.misc.functions.Function;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ListIterator;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class Transformer
implements Opcodes {
    protected ClassNode classNode;
    protected final String target = this.getClass().getDeclaredAnnotation(Target.class).value();

    protected Transformer() {
    }

    public void transform(ClassNode node) {
        this.classNode = node;
        this.process();
    }

    protected abstract void process();

    protected MethodNode getMethod(String name, String desc) {
        String targetMethod = name + desc;
        return this.classNode.methods.stream().filter(m -> targetMethod.equals(m.name + m.desc)).findFirst().orElseThrow(() -> new NoSuchMethodError("Could not find " + name + desc + " / " + targetMethod + "!"));
    }

    protected ListIterator<AbstractInsnNode> getIterator(MethodNode method, int opcode, String methodName) {
        return this.getIterator(method, opcode, (Function<AbstractInsnNode, Boolean>)((Function)m -> ((MethodInsnNode)m).name.equals(methodName)));
    }

    protected ListIterator<AbstractInsnNode> getIterator(MethodNode method, int opcode, Function<AbstractInsnNode, Boolean> nodeValidator) {
        ListIterator iterator = method.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (node.getOpcode() != opcode || !((Boolean)nodeValidator.apply((Object)node)).booleanValue()) continue;
            return iterator;
        }
        throw new IllegalStateException("Could not generate iterator!");
    }

    public String getTarget() {
        return this.target;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Target {
        public String value();
    }
}

