/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.labymod.laby3;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.l3g7.magierflamme_addon.core.api.bridges.Bridge;
import dev.l3g7.magierflamme_addon.core.api.bridges.LabyBridge;
import dev.l3g7.magierflamme_addon.core.api.event_bus.Event;
import dev.l3g7.magierflamme_addon.core.api.event_bus.EventListener;
import dev.l3g7.magierflamme_addon.core.api.event_bus.EventRegisterer;
import dev.l3g7.magierflamme_addon.core.api.reflection.Reflection;
import dev.l3g7.magierflamme_addon.core.events.GuiScreenEvent;
import dev.l3g7.magierflamme_addon.core.events.annotation_events.OnEnable;
import dev.l3g7.magierflamme_addon.core.events.annotation_events.OnStartupComplete;
import dev.l3g7.magierflamme_addon.features.Feature;
import dev.l3g7.magierflamme_addon.labymod.laby3.settings.MainPage;
import dev.l3g7.magierflamme_addon.labymod.laby3.util.Laby3Util;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.AddonInfoManager;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.api.LabyModAddon;
import net.labymod.main.LabyMod;
import net.labymod.settings.LabyModAddonsGui;
import net.labymod.settings.elements.SettingsElement;

@Bridge.ExclusiveTo(value=Bridge.Version.LABY_3)
public class Main
extends LabyModAddon {
    private static Main instance;
    private static String addonDescription;

    public static Main getInstance() {
        return instance;
    }

    public Main() {
        instance = this;
    }

    public void onEnable() {
        System.out.println("MagierFlamme Addon enabling");
        long begin = System.currentTimeMillis();
        Feature.getFeatures().forEach(Feature::init);
        EventRegisterer.init();
        Event.fire(OnEnable.class);
        Map map = LabyMod.getInstance().getDynamicTextureManager().getResourceLocations();
        map.put("magierflamme_addon_icon", Laby3Util.createDynamicTexture("magierflamme_addon/icons/icon.png", "magierflamme_addon_icon"));
        System.out.println("MagierFlamme Addon enabled! (took " + (System.currentTimeMillis() - begin) + " ms)");
    }

    @OnStartupComplete
    private static void updateDescription() {
        AddonInfoManager addonInfoManager = AddonInfoManager.getInstance();
        addonInfoManager.init();
        UUID addonUuid = Main.instance.about.uuid;
        AddonInfo addonInfo = (AddonInfo)addonInfoManager.getAddonInfoMap().get(addonUuid);
        if (addonInfo == null) {
            addonInfo = AddonLoader.getOfflineAddons().stream().filter(addon -> addon.getUuid().equals(addonUuid)).findFirst().orElse(null);
        }
        if (addonInfo == null) {
            return;
        }
        Reflection.set((Object)addonInfo, (String)"author", (Object)("L3g7, L3g73 \u2503 v" + LabyBridge.labyBridge.addonVersion()));
        Reflection.set((Object)addonInfo, (String)"description", (Object)addonDescription);
    }

    @EventListener
    private static void onGuiOpen(GuiScreenEvent.GuiOpenEvent<LabyModAddonsGui> event) {
        UUID uuid = Main.getInstance().about.uuid;
        for (AddonInfo addonInfo : AddonInfoManager.getInstance().getAddonInfoList()) {
            if (!addonInfo.getUuid().equals(uuid)) continue;
            return;
        }
        for (AddonInfo offlineAddon : AddonLoader.getOfflineAddons()) {
            if (!offlineAddon.getUuid().equals(uuid)) continue;
            AddonInfoManager.getInstance().getAddonInfoList().add(offlineAddon);
            return;
        }
        throw new RuntimeException("MagierFlamme Addon couldn't be loaded");
    }

    public void loadConfig() {
        JsonArray comment = new JsonArray();
        comment.add((JsonElement)new JsonPrimitive("Das hier ist die falsche Config-Datei!"));
        comment.add((JsonElement)new JsonPrimitive("Du findest die richtige in .minecraft/config/MagierFlamme Addon.json"));
        String absPath = Paths.get("config", "MagierFlamme Addon.json").toAbsolutePath().normalize().toString().replace('\\', '/');
        comment.add((JsonElement)new JsonPrimitive("(" + absPath + ")"));
        this.getConfig().add("_hinweis", (JsonElement)comment);
        this.saveConfig();
    }

    protected void fillSettings(List<SettingsElement> list) {
        list.addAll((Collection)Reflection.c((Object)MainPage.collectSettings()));
    }

    static {
        addonDescription = "Hi :)";
    }
}

