/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.labymod.laby4.injection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.URL;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.classobject.ClassObject;
import net.minecraft.launchwrapper.classobject.MutableClassObject;
import net.minecraft.launchwrapper.loader.BaseClassLoader;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class TransformingParentClassLoader
extends ClassLoader {
    private final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final MethodHandle transformName;
    private final MethodHandle untransformName;
    private final MethodHandle findClassObject;
    private final MethodHandle runTransformers;
    private final MethodHandle addInvalidClass;
    private final MethodHandle classObjectHolderConstructor;
    private final MethodHandle getClassLoader;
    private final MethodHandle getClassObject;

    public TransformingParentClassLoader() throws ReflectiveOperationException {
        super(Launch.classLoader.getClass().getClassLoader());
        Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        Unsafe unsafe = (Unsafe)theUnsafe.get(null);
        unsafe.putInt(this.LOOKUP, 12L, -1);
        Class<?> classObjectHolder = this.LOOKUP.findClass("net.minecraft.launchwrapper.LaunchClassLoader$ClassObjectHolder");
        this.transformName = this.findVirtual("transformName", MethodType.methodType(String.class, String.class));
        this.untransformName = this.findVirtual("untransformName", MethodType.methodType(String.class, String.class));
        this.findClassObject = this.findVirtual("findClassObject", MethodType.methodType(classObjectHolder, String.class, BaseClassLoader.class));
        this.runTransformers = this.findVirtual("runTransformers", MethodType.methodType(byte[].class, String.class, String.class, byte[].class));
        this.addInvalidClass = this.findVirtual("addInvalidClass", MethodType.methodType(Void.TYPE, String.class));
        this.classObjectHolderConstructor = this.LOOKUP.findConstructor(classObjectHolder, MethodType.methodType(Void.TYPE, BaseClassLoader.class, ClassObject.class));
        this.getClassLoader = this.LOOKUP.findVirtual(classObjectHolder, "getClassLoader", MethodType.methodType(BaseClassLoader.class));
        this.getClassObject = this.LOOKUP.findVirtual(classObjectHolder, "getClassObject", MethodType.methodType(ClassObject.class));
    }

    private MethodHandle findVirtual(String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle handle = this.LOOKUP.findVirtual(Launch.classLoader.getClass(), name, type);
        return handle.bindTo(Launch.classLoader);
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        return this.getParent().getResource(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("net.labymod.api.") || name.startsWith("net.labymod.core.")) {
            try {
                return this.transform(name);
            }
            catch (Throwable e) {
                throw new ClassNotFoundException("Couldn't load " + name, e);
            }
        }
        return this.getParent().loadClass(name);
    }

    private Class<?> transform(String name) throws Throwable {
        Object holder;
        String transformedName = this.transformName.invoke(name);
        Class cachedClass = Launch.classLoader.getCachedClass(transformedName);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            holder = this.findClassObject.invoke(name, null);
        }
        catch (ClassNotFoundException exception) {
            holder = this.classObjectHolderConstructor.invoke(Launch.classLoader, ClassObject.mutable((String)name));
        }
        ClassObject classObject = this.getClassObject.invoke(holder);
        BaseClassLoader loader = this.getClassLoader.invoke(holder);
        String untransformedName = this.untransformName.invoke(name);
        byte[] transformedClass = this.runTransformers.invoke(untransformedName, transformedName, classObject.getData());
        if (transformedClass == null) {
            this.addInvalidClass.invoke(name);
            throw new ClassNotFoundException(name);
        }
        if (name.equals("net.labymod.api.loader.platform.PlatformClassloader$TransformerPhase")) {
            return this.getParent().loadClass(name);
        }
        if (classObject instanceof MutableClassObject) {
            ((MutableClassObject)classObject).setData(transformedClass);
        }
        try {
            Class cls = loader.defineClassObject(transformedName, transformedClass, 0, transformedClass.length, classObject.getCodeSource());
            Launch.classLoader.addClassToCache(name, cls);
            return cls;
        }
        catch (Exception e) {
            this.addInvalidClass.invoke(name);
            throw new ClassNotFoundException(name, e);
        }
    }
}

