/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.post_processor;

import dev.l3g7.magierflamme_addon.post_processor.LatePostProcessor;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EarlyPostProcessor
implements IClassTransformer {
    public static final EarlyPostProcessor INSTANCE = new EarlyPostProcessor();
    public static final Field modCountField;
    public static final Field renameTransformerField;
    public final LatePostProcessor lateProcessor = new LatePostProcessor();
    public boolean decoupled = false;

    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        String fileName = transformedName.replace('.', '/').concat(".class");
        if (!fileName.startsWith("dev/l3g7/magierflamme_addon/")) {
            return classBytes;
        }
        classBytes[7] = 52;
        if (this.decoupled || this.registerProcessors()) {
            return classBytes;
        }
        classBytes = this.lateProcessor.transform(fileName, transformedName, classBytes);
        return classBytes;
    }

    public boolean registerProcessors() {
        if (renameTransformerField == null) {
            return false;
        }
        try {
            if (renameTransformerField.get(Launch.classLoader) != null) {
                this.decoupled = true;
                Field transformersField = LaunchClassLoader.class.getDeclaredField("transformers");
                transformersField.setAccessible(true);
                List transformers = (List)transformersField.get(Launch.classLoader);
                int modCount = (Integer)modCountField.get(transformers);
                transformers.add(this.lateProcessor);
                modCountField.set(transformers, modCount);
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    static {
        if (Launch.classLoader == null) {
            modCountField = null;
            renameTransformerField = null;
        } else {
            try {
                modCountField = AbstractList.class.getDeclaredField("modCount");
                modCountField.setAccessible(true);
                renameTransformerField = LaunchClassLoader.class.getDeclaredField("renameTransformer");
                renameTransformerField.setAccessible(true);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

