/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.post_processor;

import dev.l3g7.magierflamme_addon.post_processor.processors.AccessElevator;
import dev.l3g7.magierflamme_addon.post_processor.processors.MixinLibSwapper;
import dev.l3g7.magierflamme_addon.post_processor.processors.StringConcatShim;
import dev.l3g7.magierflamme_addon.post_processor.processors.SuperclassRemapper;
import dev.l3g7.magierflamme_addon.post_processor.processors.SwitchDowngrader;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class LatePostProcessor
implements IClassTransformer {
    public static final List<Processor> processors = Arrays.asList(new StringConcatShim(), new SwitchDowngrader(), new AccessElevator(), new MixinLibSwapper(), new SuperclassRemapper());
    public String transformedClass;

    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        this.transformedClass = transformedName.replace('.', '/');
        if (!this.transformedClass.startsWith("dev/l3g7/magierflamme_addon/")) {
            return classBytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(classBytes);
        reader.accept((ClassVisitor)classNode, 0);
        boolean modified = false;
        for (Processor processor : processors) {
            processor.process(classNode);
            modified |= processor.modified;
            processor.reset();
        }
        if (!modified) {
            return classBytes;
        }
        BoundClassWriter writer = new BoundClassWriter();
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static abstract class Processor {
        public boolean modified = false;

        public abstract void process(ClassNode var1);

        public void reset() {
            this.modified = false;
        }

        public void setModified() {
            this.modified = true;
        }
    }

    protected class BoundClassWriter
    extends ClassWriter {
        public BoundClassWriter() {
            super(3);
        }

        public String getCommonSuperClass(String type1, String type2) {
            if (type1.equals(LatePostProcessor.this.transformedClass) || type2.equals(LatePostProcessor.this.transformedClass)) {
                return "java/lang/Object";
            }
            return super.getCommonSuperClass(type1, type2);
        }
    }
}

