/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.post_processor.processors;

import dev.l3g7.magierflamme_addon.core.api.mapping.Mapper;
import dev.l3g7.magierflamme_addon.core.api.mapping.Mapping;
import dev.l3g7.magierflamme_addon.post_processor.LatePostProcessor;
import dev.l3g7.magierflamme_addon.post_processor.processors.StringConcatShim;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.ListIterator;
import net.labymod.core.asm.LabyModCoreMod;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SuperclassRemapper
extends LatePostProcessor.Processor
implements Opcodes {
    @Override
    public void process(ClassNode classNode) {
        boolean obfuscatedClasses;
        if (classNode.name.startsWith("dev/l3g7/magierflamme_addon/core/api/")) {
            return;
        }
        ArrayList<String> minecraftClasses = new ArrayList<String>();
        try {
            obfuscatedClasses = !LabyModCoreMod.isForge();
        }
        catch (NoClassDefFoundError error) {
            obfuscatedClasses = false;
        }
        ClassNode cb = this.getClass(classNode.superName);
        do {
            String mappedName;
            if (cb.name.startsWith("net/minecraft/")) {
                minecraftClasses.add(cb.name);
                continue;
            }
            if (cb.name.contains("/") || !(mappedName = Mapper.mapClass((String)cb.name, (Mapping)Mapping.OBFUSCATED, (Mapping)Mapping.UNOBFUSCATED)).startsWith("net/minecraft/")) continue;
            minecraftClasses.add(mappedName);
        } while ((cb = this.getClass(cb.superName)) != null);
        if (minecraftClasses.isEmpty()) {
            return;
        }
        ListIterator<MethodNode> it = classNode.methods.listIterator();
        block3: while (it.hasNext()) {
            MethodNode method = (MethodNode)it.next();
            block4: for (AbstractInsnNode node : method.instructions) {
                String mappedName;
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode methodInsn = (MethodInsnNode)node;
                    for (String minecraftClass : minecraftClasses) {
                        mappedName = obfuscatedClasses ? Mapper.mapMethodName((String)minecraftClass, (String)methodInsn.name, (String)this.deobfuscateDesc(methodInsn.desc), (Mapping)Mapping.UNOBFUSCATED, (Mapping)Mapping.OBFUSCATED) : Mapper.mapMethodName((String)minecraftClass, (String)methodInsn.name, (String)methodInsn.desc, (Mapping)Mapping.UNOBFUSCATED, (Mapping)Mapping.SEARGE);
                        if (methodInsn.name.equals(mappedName)) continue;
                        methodInsn.name = mappedName;
                        this.setModified();
                        continue block4;
                    }
                    continue;
                }
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                for (String minecraftClass : minecraftClasses) {
                    mappedName = Mapper.mapField((String)minecraftClass, (String)field.name, (Mapping)Mapping.UNOBFUSCATED, (Mapping)(obfuscatedClasses ? Mapping.OBFUSCATED : Mapping.SEARGE));
                    if (field.name.equals(mappedName)) continue;
                    field.name = mappedName;
                    this.setModified();
                    continue block4;
                }
            }
            for (String minecraftClass : minecraftClasses) {
                String mappedName = obfuscatedClasses ? Mapper.mapMethodName((String)minecraftClass, (String)method.name, (String)this.deobfuscateDesc(method.desc), (Mapping)Mapping.UNOBFUSCATED, (Mapping)Mapping.OBFUSCATED) : Mapper.mapMethodName((String)minecraftClass, (String)method.name, (String)method.desc, (Mapping)Mapping.UNOBFUSCATED, (Mapping)Mapping.SEARGE);
                if (method.name.equals(mappedName)) continue;
                MethodNode bridge = new MethodNode(method.access | 0x1000, method.name, method.desc, method.signature, method.exceptions.toArray(new String[0]));
                int varIdx = 0;
                bridge.instructions.add((AbstractInsnNode)new VarInsnNode(25, varIdx++));
                for (Type type : Type.getArgumentTypes((String)method.desc)) {
                    bridge.instructions.add((AbstractInsnNode)new VarInsnNode(this.getLoadOpcode(type), varIdx++));
                }
                method.name = mappedName;
                bridge.instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, method.name, method.desc, false));
                bridge.instructions.add((AbstractInsnNode)new InsnNode(this.getReturnOpcode(Type.getReturnType((String)method.desc))));
                it.add(bridge);
                this.setModified();
                continue block3;
            }
        }
    }

    public int getLoadOpcode(Type type) {
        int n;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n = 21;
                break;
            }
            case 7: {
                n = 22;
                break;
            }
            case 6: {
                n = 23;
                break;
            }
            case 8: {
                n = 24;
                break;
            }
            case 9: 
            case 10: {
                n = 25;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(type.getSort()));
            }
        }
        return n;
    }

    public int getReturnOpcode(Type type) {
        int n;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n = 172;
                break;
            }
            case 7: {
                n = 173;
                break;
            }
            case 6: {
                n = 174;
                break;
            }
            case 8: {
                n = 175;
                break;
            }
            case 9: 
            case 10: {
                n = 176;
                break;
            }
            case 0: {
                n = 177;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(type.getSort()));
            }
        }
        return n;
    }

    public String deobfuscateDesc(String desc) {
        Type[] argumentTypes = Mapper.mapTypes((Type[])Type.getArgumentTypes((String)desc), (Mapping)Mapping.OBFUSCATED, (Mapping)Mapping.UNOBFUSCATED);
        Type returnType = Mapper.mapType((Type)Type.getReturnType((String)desc), (Mapping)Mapping.OBFUSCATED, (Mapping)Mapping.UNOBFUSCATED);
        return Type.getMethodDescriptor((Type)returnType, (Type[])argumentTypes);
    }

    public ClassNode getClass(String name) {
        byte[] bytes;
        if (name == null) {
            return null;
        }
        try {
            bytes = this.getClassBytes(name);
        }
        catch (IOException e) {
            throw new RuntimeException((String)((Object)StringConcatShim.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Couldn't find class bytes for \u0001"}, (String)name)), e);
        }
        bytes[7] = 52;
        ClassNode node = new ClassNode();
        new ClassReader(bytes).accept((ClassVisitor)node, 0);
        return node;
    }

    public byte[] getClassBytes(String name) throws IOException {
        byte[] classBytes;
        if (Launch.classLoader != null && (classBytes = Launch.classLoader.getClassBytes(name)) != null) {
            return classBytes;
        }
        String resourcePath = name.replace('.', '/').concat(".class");
        ClassLoader classLoader = Launch.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)classLoader;
            return this.readClassBytes(name, ucl.getResourceAsStream(resourcePath));
        }
        try (URLClassLoader ucl = new URLClassLoader(new URL[0], Launch.class.getClassLoader());){
            byte[] byArray = this.readClassBytes(name, ucl.getResourceAsStream(resourcePath));
            return byArray;
        }
    }

    public byte[] readClassBytes(String name, InputStream in) throws IOException {
        if (in == null) {
            String mappedName;
            String internalName = name.replace('.', '/');
            if (internalName.equals(mappedName = Mapper.mapClass((String)internalName, (Mapping)Mapping.UNOBFUSCATED, (Mapping)Mapping.OBFUSCATED))) {
                throw new IOException((String)((Object)StringConcatShim.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Cannot find class bytes of unmapped class \u0001"}, (String)internalName)));
            }
            return this.getClassBytes(mappedName);
        }
        try (InputStream inputStream = in;){
            int read;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer, 0, 4096)) >= 0) {
                output.write(buffer, 0, read);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }
}

