/*
 * Decompiled with CFR 0.152.
 */
package dev.l3g7.magierflamme_addon.post_processor.processors;

import dev.l3g7.magierflamme_addon.post_processor.LatePostProcessor;
import java.util.ListIterator;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SwitchDowngrader
extends LatePostProcessor.Processor
implements Opcodes {
    @Override
    public void process(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            ListIterator it = method.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)it.next();
                if (node instanceof TypeInsnNode) {
                    TypeInsnNode e = (TypeInsnNode)node;
                    if (e.getOpcode() != 187 || !e.desc.equals("java/lang/MatchException")) continue;
                    e.desc = "java/lang/RuntimeException";
                    this.setModified();
                    continue;
                }
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode e = (MethodInsnNode)node;
                    if (e.getOpcode() != 183 || !e.owner.equals("java/lang/MatchException")) continue;
                    e.owner = "java/lang/RuntimeException";
                    this.setModified();
                    continue;
                }
                if (!(node instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode e = (InvokeDynamicInsnNode)node;
                if (!e.bsm.getOwner().equals("java/lang/runtime/SwitchBootstraps") || !e.bsm.getName().equals("typeSwitch")) continue;
                it.remove();
                assert (e.bsmArgs.length <= Short.MAX_VALUE);
                it.add(new IntInsnNode(17, e.bsmArgs.length));
                it.add(new TypeInsnNode(189, "java/lang/Class"));
                for (int i = 0; i < e.bsmArgs.length; ++i) {
                    it.add(new InsnNode(89));
                    it.add(new LdcInsnNode((Object)i));
                    it.add(new LdcInsnNode(e.bsmArgs[i]));
                    it.add(new InsnNode(83));
                }
                it.add(new MethodInsnNode(184, SwitchDowngrader.class.getName().replace('.', '/'), "typeSwitch", "(Ljava/lang/Object;I[Ljava/lang/Class;)I"));
            }
        }
    }

    public static int typeSwitch(Object o, int n, Class<?>[] classes) {
        assert (n == 0);
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].isInstance(o)) continue;
            return i;
        }
        return -2;
    }
}

